IF COL_LENGTH('WebProcesos', 'Id_Cliente') IS NULL 
BEGIN
	ALTER TABLE WebProcesos ADD Id_Cliente INT
END
GO 


IF EXISTS ( SELECT * 
            FROM   sysobjects 
            WHERE  id = object_id(N'CPJ_WebProcesos') 
                   and OBJECTPROPERTY(id, N'IsProcedure') = 1 )
BEGIN
    DROP PROCEDURE CPJ_WebProcesos
END
GO

CREATE PROCEDURE CPJ_WebProcesos		@pJson VARCHAR(8000)
AS 
SET NOCOUNT ON

IF NOT EXISTS (SELECT * FROM sysobjects WHERE Name='WebProcesos' AND xtype='U')
BEGIN 
	SELECT 1 as Nro_Operacion, 1 as Nro_Operacion_Externo
	RETURN 0
END

/*Variables recibidas por parametro a traves del JSON*/
DECLARE @pFlagUsarTrans				TINYINT
		,@pModoDebug				TINYINT
		,@pId_Cliente				INT
		,@pTipo_Operacion			CHAR(1)
		,@pNro_Operacion			VARCHAR(100)
		,@pNro_Operacion_Externo	VARCHAR(100)
		,@pJsonDatos				VARCHAR(8000)
		,@pJsonDatosSep				CHAR(1)
		,@pPrefijo					VARCHAR(10)
		,@pTamanio					INT
		,@pAccion					CHAR(1)



SET @pFlagUsarTrans			= ISNULL(CONVERT(TINYINT, dbo.CF_JSON_VALUE(@pJson,'FlagUsarTrans')), 0)
SET @pModoDebug				= ISNULL(CONVERT(TINYINT, dbo.CF_JSON_VALUE(@pJson,'ModoDebug')), 0)
SET @pId_Cliente			= ISNULL(CONVERT(INT, dbo.CF_JSON_VALUE(@pJson,'Id_Cliente')), 0)
SET @pTipo_Operacion		= ISNULL(CONVERT(CHAR(2), dbo.CF_JSON_VALUE(@pJson,'Tipo_Operacion')), '')
SET @pNro_Operacion			= ISNULL(CONVERT(VARCHAR(100), dbo.CF_JSON_VALUE(@pJson,'Nro_Operacion')), '')
SET @pNro_Operacion_Externo	= ISNULL(CONVERT(VARCHAR(100), dbo.CF_JSON_VALUE(@pJson,'Nro_Operacion_Externo')), '')
SET @pJsonDatos				= ISNULL(CONVERT(VARCHAR(8000), dbo.CF_JSON_VALUE(@pJson,'JsonDatos')), '')
SET @pJsonDatosSep			= ISNULL(CONVERT(CHAR(1), dbo.CF_JSON_VALUE(@pJson,'JsonDatosSep')), '')
SET @pPrefijo				= ISNULL(CONVERT(VARCHAR(10), dbo.CF_JSON_VALUE(@pJson,'Prefijo')), '')
SET @pTamanio				= ISNULL(CONVERT(INT, dbo.CF_JSON_VALUE(@pJson,'Tamanio')), 12)
SET @pAccion				= ISNULL(CONVERT(CHAR(1), dbo.CF_JSON_VALUE(@pJson,'Accion')), 'A')  --A=Agregar


/*Variables Locales*/
/*FIN Variables Locales*/

BEGIN TRY
	IF @pFlagUsarTrans <> 0 
	BEGIN
		BEGIN TRAN
	END

	IF(@pModoDebug = 1)
	BEGIN
		PRINT 'Ingreso a Stored Procedure: CPJ_WebProcesos'
		PRINT 'Parametros: '+ @pJson  
	END

	/*====================================================================================================================================================*/
	
	SET @pJsonDatos = REPLACE(@pJsonDatos,@pJsonDatosSep,'"')
	
	INSERT INTO WebProcesos (Id_Cliente, Tipo_Operacion, Nro_Operacion, Nro_Operacion_Externo, 
					Fecha_Creacion, Id_Estado, [Json]) 
					VALUES (@pId_Cliente,@pTipo_Operacion,@pNro_Operacion,@pNro_Operacion_Externo,
								GETDATE(),0,@pJsonDatos)
    SET @pNro_Operacion_Externo = @@IDENTITY
	SET @pNro_Operacion = RTRIM(LTRIM(@pPrefijo)) + RIGHT('000000000000000000000000000000' + CONVERT(VARCHAR(50), @@IDENTITY), @pTamanio - LEN(@pPrefijo))

	UPDATE WebProcesos SET 	Nro_Operacion = @pNro_Operacion	, Nro_Operacion_Externo = @pNro_Operacion_Externo		
				WHERE Id_Web_Proceso = @@IDENTITY

	/*====================================================================================================================================================*/

	IF @pFlagUsarTrans <> 0 COMMIT

	SELECT @pNro_Operacion as Nro_Operacion, @pNro_Operacion_Externo as Nro_Operacion_Externo , @@IDENTITY AS Id_Web_Proceso

	
	IF(@pModoDebug = 1)
	BEGIN
		PRINT 'Fin Stored Procedure: CPJ_WebProcesos'
	END
	
END TRY  


BEGIN CATCH  
    EXECUTE usp_GetErrorInfo

	IF @pFlagUsarTrans <> 0  ROLLBACK

	RETURN 9999
END CATCH

RETURN 0 


/*
 
EXEC CPJ_WebProcesos '{"ModoDebug":"1","FlagUsarTrans":"1","Id_Cliente":"1","Tipo_Operacion":"P","JsonDatos":"","Prefijo":"P","Tamanio":"12","Accion":"A"}'
select TOP 1 * from webprocesos ORDER BY 1 DESC

*/

